#!/bin/bash

BLUE='\033[0;34m'
RED='\033[0;31m'
NC='\033[0m' # No Color
#wget https://s3.eu-west-1.amazonaws.com/assets.cyolo.io/<version>-cyolo-build.tar.gz
#tar -xzvf *-cyolo-build.tar.gz


install_docker_rhel()
{
        ## Uninstall exisiting docker packages
        dnf remove docker \
                  docker-client \
                  docker-client-latest \
                  docker-common \
                  docker-latest \
                  docker-latest-logrotate \
                  docker-logrotate \
                  docker-engine \
                  podman \
                  runc

        ## List of packages, the order to crutial
        case ${VERSION} in
	  "el8") rpms="libslirp-4.4.0-2.module+el8.10.0+22417+2fb00970.x86_64.rpm slirp4netns-1.2.3-1.module+el8.10.0+22417+2fb00970.x86_64.rpm libcgroup-0.41-19.el8.x86_64.rpm container-selinux-2.229.0-2.module+el8.10.0+22417+2fb00970.noarch.rpm fuse3-libs-3.3.0-19.el8.x86_64.rpm fuse3-3.3.0-19.el8.x86_64.rpm fuse-overlayfs-1.13-1.module+el8.10.0+22417+2fb00970.x86_64.rpm containerd.io-1.7.24-3.1.el8.x86_64.rpm docker-ce-27.4.1-1.el8.x86_64.rpm docker-ce-cli-27.4.1-1.el8.x86_64.rpm docker-ce-rootless-extras-27.4.1-1.el8.x86_64.rpm docker-buildx-plugin-0.19.3-1.el8.x86_64.rpm docker-compose-plugin-2.32.1-1.el8.x86_64.rpm";;
	  "el9") rpms="libslirp-4.4.0-8.el9.x86_64.rpm libnftnl-1.2.6-4.el9_4.x86_64.rpm iptables-nft-1.8.10-4.el9_4.x86_64.rpm slirp4netns-1.3.1-1.el9.x86_64.rpm fuse-common-3.10.2-9.el9.x86_64.rpm fuse3-libs-3.10.2-9.el9.x86_64.rpm fuse3-3.10.2-9.el9.x86_64.rpm fuse-overlayfs-1.14-1.el9.x86_64.rpm  container-selinux-2.232.1-1.el9.noarch.rpm containerd.io-1.7.24-3.1.el9.x86_64.rpm docker-ce-cli-27.4.1-1.el9.x86_64.rpm docker-ce-27.4.1-1.el9.x86_64.rpm docker-ce-rootless-extras-27.4.1-1.el9.x86_64.rpm";;
	      *) echo "Unsupported Version - ${OS} - ${VERSION}"; exit 1;;
        esac

        cd ./docker/rhel/${VERSION}
        if (( $? )); then
          echo "Failed to move to folder ./docker/rhel/${VERSION}"
          exit 1
        fi

        ## Extracting the list of RPMs
        for rpm in ${rpms};  do
        echo "Extracting RPM ${rpm}"
                dnf localinstall ${rpm} -y --disablerepo=*
        done
        cd -
}

# In the case a silent execution set the value to false
if [[ -z "${INTERACTIVE}" ]]; then
  INTERACTIVE="true"
fi

case $# in
  2) inst_type=$(echo $1 | tr '[:upper:]' '[:lower:]'); installation=$(echo $2 | tr '[:upper:]' '[:lower:]');;
  *) echo "Usage offline-installer.sh <idac/pg/both> <online/offline>"; exit 1;;
esac

# validate inputs
case $inst_type in
  "pg"|"idac"|"both") ;;
  *) echo "Error> wrong input ${inst_type} - <idac/pg/both>"; exit 2;;
esac

case $installation in
  "offline"|"online") ;;
  *) echo "Error> wrong input ${installation} - <online/offline>"; exit 3;;
esac

echo -e "${BLUE}=== Searching for OS version ===${NC}\n"

if [ -f /etc/os-release ]; then
   OS=$(grep -E '^ID=' /etc/os-release| awk -F"=" '{print $2}'|sed -e 's/\"//g')
   case ${OS} in
     "rhel")
        VERSION=$(grep PLATFORM_ID /etc/os-release| awk -F":" '{print $2}'|sed -e 's/\"//g');
        echo -e "${BLUE}=== Recognized ${OS} ${VERSION} ===${NC}\n";
        install_docker_rhel
        ;;
     "ubuntu")
        VERSION=$(grep UBUNTU_CODENAME /etc/os-release| awk -F"=" '{print $2}');
        echo -e "${BLUE}=== Recognized ${OS} ${VERSION} ===${NC}\n";
        command -v iptables
        if (( $? )); then
	   sudo dpkg -i ./iptables/ubuntu/${VERSION}/*;
        else
           echo "Already installed, skipping ..."
        fi
        command -v docker
        if (( $? )); then
           sudo dpkg -i ./docker/ubuntu/${VERSION}/*;
        else
           echo "Already installed, skipping ..."
        fi
        ;;
     *) echo "Unsupported OS - ${OS}"; exit 1;;
   esac
fi

echo -e "${BLUE}=== Creating directories... ===${NC}\n"

sudo mkdir /etc/cyolo
sudo mkdir /etc/cyolo/certs
sudo mkdir /etc/cyolo/config
sudo cp ./examples/${inst_type}-docker-compose.yml /etc/cyolo/config/docker-compose.yml
sudo mv ./examples /etc/cyolo/examples

# confirm license & certificate file exists
echo -e "${BLUE}=== Confirm License & Certificate files exists ===${NC}\n"
if [[ "${INTERACTIVE}" == true ]]; then
  echo -e "\nPlease confirm certificate (*.pem) files exists\n"
  ls *.pem
  echo "Press to continue"
  read x
  if [[ "$inst_type" == idac || "$inst_type" == both ]]; then
    echo -e "\nPlease make sure license.cyolo exists\n"
    ls license.cyolo
    echo "Press to continue"
    read x
  fi
fi
echo -e "\n${BLUE}=== Copying License & Certificate files ===${NC}\n"
sudo cp license.cyolo /etc/cyolo/certs/
if (( $? )); then
  echo -e "${RED}Error> failed to copy license.cyolo file${NC}"
  echo "Please fix before starting the services"
  if [[ "${INTERACTIVE}" == true ]]; then
    echo "Press any key to continue ..."
    read x
  fi
fi

sudo cp *.pem /etc/cyolo/certs/
if (( $? )); then
  echo -e "${RED}Error> failed to copy certificate file(s)${NC}"
  echo "Please fix before starting the services"
fi

docker --version
if (( $? )); then
  echo -e "${RED}Error> failed to to install docker${NC}"
  echo "Please fix before starting the services"
  echo "Press any key to continue ..."
  read x
fi

echo -e "${BLUE}=== Downloading Docker Images... ===${NC}"

if [[ "${installation}" == "online" ]]; then
  echo -e "\nPulling docker images ...\n"
  sudo ./pull.sh
else
  echo -e "\nLoading docker images ...\n"
  sudo ./load.sh
fi

echo -e "${BLUE}=== List of Docker Images... ===${NC}"
docker image ls --digests

echo -e "${BLUE}=== Starting Docker Service... ===${NC}"
sudo systemctl enable docker
sudo systemctl start docker

echo -e "${BLUE}=== Installation Completed... ===${NC}"
cd ../../ && pwd
if [ -d ./tmp ];then
        rm -rf ./tmp
fi
