#!/bin/bash
### Conf
mkdir -p /etc/netplan/backup
dtn=`date +%Y%m%dT%H%M%S`
file=/home/cyolo/netplan.conf
tmp_netplan=/tmp/netplan.tmp
rm -f $tmp_netplan
### Func
#
function func_apply_netplan () {
  sleep 1	
  echo "Applying new network configuration"
  echo "Renaming old netplan files - adding suffix '$dtn'"
  find /etc/netplan/ -maxdepth 1 -type f | awk -F"\/" '{print $NF}' 2>/dev/null | while read FILENAME; do
    mv /etc/netplan/$FILENAME /etc/netplan/backup/$FILENAME-$dtn
  done
  cp $tmp_netplan /etc/netplan/01-network-script.yaml
  chmod 600 /etc/netplan/01-network-script.yaml
  /usr/sbin/netplan apply 0>/dev/null 1>/dev/null 2>/dev/null
}	
#
function func_static_or_dhcp () {
  sleep 1	
  read -p "## Please choose IP type:  STATIC (1) or DHCP (0), [0 or 1]: " choise
  case "$choise" in
  1 ) static=1;;
  0 ) static=0;;
  * ) func_static_or_dhcp;;
esac
}	
#
function func_modify_netplan () {
  sleep 1	
  func_network_inf
  func_static_or_dhcp
  if [ "$static" == "1" ];then
    file_static=1	  
    func_ip_addr
    func_dgw
    func_sds
    func_dns
    func_update_netplan_file
  else
    file_static=0
    func_update_netplan_file
  fi
}
#
function func_network_inf () {
  sleep 1	
  numOfInf=`ip -o link show | awk -F ': ' '{print $2}'| grep -e ^en -e ^eth| wc -l`
  if [ "$numOfInf" -gt "1" ];then
    echo "## Your available network interfaces are:"; echo ""
    ip -o link show | awk -F ': ' '{print $2}'| grep -e ^en -e ^eth
    echo ""    
    read -p "## Please type the network interface id to configure:" file_inf_id
  elif [ "$numOfInf" == "1" ];then
    file_inf_id=`ip -o link show | awk -F ': ' '{print $2}'| grep -e ^en -e ^eth`
  else
    read -p "## Please manually type the network interface id:" file_inf_id
  fi	  
}
#
function func_ip_addr () {
  sleep 1
  read -p "## The IP address was pre-set to: [$ipaddr], please type yes(y) or modify(m) [y or m]?" choice
  case "$choice" in
    y ) file_ip_addr=$ip_addr;;
    m ) read -p "## Please type the VM IP address (ends with '/netmask_bits', like 1.1.1.1/24): " file_ipaddr;;
    * ) func_ip_addr;;
   esac
}
#
function func_dgw () {
  sleep 1	
  read -p "## The default GW address was pre-set to: [$ipgw], please type yes(y) or modify(m) [y or m]?" choice
  case "$choice" in
    y ) file_ip_dgw=$ipdgw;;
    m ) read -p "## Please type the VM default GW address: " file_ipgw;;
    * ) func_dgw;;
  esac
}
#
function func_sds () {
  sleep 1	
  read -p "## The search domains was pre-set to: [$sds], please type yes(y) or modify(m) [y or m]?" choice
  case "$choice" in
    y ) file_sds=$sds;;
    m ) read -p "## Please type the updated search domains IPs, sperated by coma ',': " file_sds;;
    * ) func_sds;;
  esac
}
#
function func_dns () {
  sleep 1	
  read -p "## The DNS was pre-set to: [$dns], please type yes(y) or modify(m) [y or m]: " choice
  case "$choice" in
    y ) file_dns=$dns;;
    m ) read -p "## Please type the updated DNS IPs, sperated by coma ',': " file_dns;;
    * ) func_dns;;
  esac
}
#
function func_update_netplan_file () {
  if [ "$file_static" = "0" ];then
    echo "#### DHCP ####
network:
  version: 2
  renderer: networkd
  ethernets:
    $file_inf_id:
      dhcp4: true" > $tmp_netplan
  else
    echo "#### Static IP #####
network:
  version: 2
  renderer: networkd
  ethernets:
    $file_inf_id:
      addresses:
        - $file_ipaddr
      routes:
        - to: default
          via: $file_ipgw
      nameservers:
          search: [$file_sds]
          addresses: [$file_dns]" > $tmp_netplan   
  fi
  echo "## The planned netplan configuration is:"; 
  echo "---------------------------------------------------------------"
  cat $tmp_netplan
  echo "---------------------------------------------------------------"
  sleep 1
  read -p "## Proceed or Cancel, type options: yes(y) or cancel(c) [y or c]? " choice
  case "$choice" in
    y|Y ) g=1;;
    c ) echo "Netplan configuration was cancelled, Exiting..." && exit 1;;
    * ) func_update_netplan_file;;
  esac
}
#
function func_check_root_user () {
  status=`whoami | grep -q root; echo $?`
  if (( ${status} )); then
    echo "## Error, You must run the script as 'root' user (use are user: `whoami`), Exiting..."
    exit 1
  fi
}
#
function func_check_netplan () {
sleep 1
echo "########## Network configurations updated, Sleeping 10 seconds before running checks:"; sleep 10; echo ""
echo "## The VM IP is now configured as follows:"
echo "-----------------------------------------------------------------------"
ifconfig ens32 | grep inet | grep netmask
ip_stat=`ifconfig $file_inf_id | grep inet | grep netmask`
ip=`echo $ip_stat | awk '{print $2}' `
echo "-----------------------------------------------------------------------"
sleep 0.5
if [ "$ip_stat" == "" ]; then
  echo "## Error! the new netplan configuration was not applied correctly on the machine"
else
  echo "## New IP $ip was successfuly configured on the VM"; sleep 0.5
  echo "## Checking PING to the default GW:"; sleep 0.5
  GW=`netstat -rn | grep $file_inf_id | grep ^0.0.0.0 | awk '{print $2}'`
  ping_gw=`ping -c 2 $GW | echo $?`
  if [ "$ping_gw" != "0" ]; then
    echo "## Error! the Default Gateway IP under 'netstat -rn' ($GW) (netplan $file_ipgw) is not reachable"
  else
    echo "## The Default Gateway ($GW) is answering to PING - OK"
  fi
fi
}
#
function func_add_replace_pg () {
echo "" > /tmp/etc.hosts.tmp
need=0
cat /etc/hosts | while read line; do
  replace_line=`echo $line | grep -vE '^[[:space:]]*#.*'$2'' | grep $2`
  if [ "$replace_line" == "" ]; then
    echo "$line" >> /tmp/etc.hosts.tmp
  else
    words_cnt=`echo $line| wc -w`
    if [ "$words_cnt" -gt "2" ];then
      hosts_pg_ip=`echo $line | awk '{print $1}'`
      if [ "$hosts_pg_ip" != "$1" ]; then
        echo "$line" | sed 's/'$2'//g' >> /tmp/etc.hosts.tmp
        need=1
      else
        echo "$line" >> /tmp/etc.hosts.tmp
      fi
    fi
  fi
done
#
if [ "$need" == "1" ]; then
  echo "$1    $2" >> /tmp/etc.hosts.tmp
else
  exist=`cat /tmp/etc.hosts.tmp | grep -vE '^[[:space:]]*#.*'$2'' | grep $2`
  if [ "$exist" == "" ];then
    echo "$1    $2" >> /tmp/etc.hosts.tmp
  fi
fi
cat /tmp/etc.hosts.tmp > /etc/hosts
}
#
function func_config_pg_proxy () {
idac_config=/etc/cyolo/config/docker-compose.yml
edge_as_proxy=`cat $idac_config | grep USE_EDGE_PROXY | grep -vE '^[[:space:]]*#.*USE_EDGE_PROXY' | grep true`
upstream_sni=`cat $idac_config  | grep UPSTREAM_SNI | grep -vE '^[[:space:]]*#.*UPSTREAM_SNI='  | grep "\- UPSTREAM_SNI=" | awk -F \# '{print $1}' | awk -F \= '{print $2}'`
#
if [ "$edge_as_proxy" != "" ]; then
  echo "## Found Proxy configuration 'true' in iDAC docker compose, checking proxy hostname pg-proxy.$upstream_sni"
  resolve=`nslookup pg-proxy.$upstream_sni 8.8.8.8 | grep -oP '(?<=Address: )[0-9.]+' | head -n1`
  #
  if [ "$resolve" != "" ];then
    echo "## Hostname pg-proxy.$upstream_sni is resolvable with IP: $resolve, No need to add the proxy hostname in hosts file."
    exit 0    
  fi
  #
  upstream=`cat $idac_config | awk -F '- UPSTREAM=' '{print $2}'| awk -F \: '{print $1}' | grep -v ^$`
  echo "$upstream" | grep -E '^[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+$' >/dev/null && upstream_type=IP || upstream_type=HOSTNAME
  #
  if [ "$upstream_type" == "IP" ]; then
    echo "## UPSTREAM has IP value, Adding to /etc/hosts a record with Name: pg-proxy.$upstream_sni and IP: $upstream"
    func_add_replace_pg $upstream pg-proxy.$upstream_sni
  else
    echo "## UPSTREAM has HOST value, Checking if HOST IP is resolvable"
    host_resolve=`nslookup $upstream | grep -oP '(?<=Address: )[0-9.]+' | head -n1`
    #
    if [ "$host_resolve" != "" ];then
      echo "## UPSTREAM hostname $upstream is resolvable with IP: $host_resolve, Adding to /etc/hosts a record with Name: pg-proxy.$upstream_sni and IP: $host_resolve"
      func_add_replace_pg $host_resolve pg-proxy.$upstream_sni
    else
      echo "## UPSTREAM host $upstream is not resolvable, Please check it. pg-proxy.$upstream cannot be added to /etc/hosts"
      exit 1
    fi
  fi
fi
}
#
### Main
echo "###################################################################"
echo "##########        Cyolo Netplan Configurator:        ##############"
echo "###################################################################"; echo ""
#
func_check_root_user
#
func_network_inf #file_inf_id
#
static=`cat $file | grep 'netplan.static.enable'| awk -F \= '{print $2}'` ; file_static=$static
#
ipaddr=`cat $file | grep 'netplan.static.ipaddr'| awk -F \= '{print $2}'` ; file_ipaddr=$ipaddr
#
ipgw=`cat $file | grep 'netplan.static.ipgw'| awk -F \= '{print $2}'`     ; file_ipgw=$ipgw
#
sds=`cat $file | grep 'netplan.search_domains'| awk -F \= '{print $2}'`   ; file_sds=$sds
#
dns=`cat $file | grep 'netplan.dns'| awk -F \= '{print $2}'`              ; file_dns=$dns
#
func_update_netplan_file
#
read -p "## Please approve before applying, type options: yes(y) or modify(m) or cancel(c) [y or m or c]? " choice
case "$choice" in
  y|Y ) func_apply_netplan;;
  m   ) func_modify_netplan
        func_apply_netplan;;
  c   ) echo "Netplan configuration was cancelled, Exiting..." && exit 1;;
  *   ) echo "Error, invalid choice" && exit 1;;
esac
#
func_check_netplan
#
func_config_pg_proxy
